# Intuition
<!-- Describe your first thoughts on how to solve this problem. -->
Applying unitary method of doing permutations in code way.

# Approach
<!-- Describe your approach to solving the problem. -->

Permutations basically means arrangements, so when we permute we keep a record of what we have already included and look for various ways to arrange the numbers.

Same here : 
-  I have considered all numbers of the given array as starting number one-by-one
-  In next step include next number but not that one which is already included in that way 
- Keep iterating till our way reach the array size
- Add that way to answer
- Now step back and explore other numbers
- All this will happen recursively





Have a look at the code , still have any confusion then please let me know in the comments
Keep Solving.:)
# Complexity
- Time complexity : $$O(n*n!)$$
<!-- Add your time complexity here, e.g. $$O(n)$$ -->

- Space complexity : $$O(n*n!)$$
<!-- Add your space complexity here, e.g. $$O(n)$$ -->

# Code
```
class Solution {
    public List<List<Integer>> permute(int[] nums) {
        
        List<List<Integer>> a = new ArrayList<>();
        recursepermute( nums, new boolean[nums.length], new ArrayList<>(), a);
        return a;
    }

    static void recursepermute( int[] nums, boolean[] included, List<Integer> way, List<List<Integer>> a){

        if( way.size() == nums.length){
            a.add( new ArrayList<>( way ) );
            return;
        }

        for( int i = 0; i < nums.length; i++){
            if( included[i] ){                   // if that number is already included in our that way , then look for next numbers
                continue;
            }
            way.add( nums[i]);                   // if not , then add to our way
            included[i] = true;
            recursepermute( nums, included, way, a);   // now  recurse until our way size equals desired array size
            way.remove( way.size() - 1 );              // remove last numbers to look for another way
            included[i] = false;
        }
    }
}
```